@extends('admin.layout.page-app')
@section('page_title', __('label.coin_settings'))
@section('tab_title', __('label.coin_settings'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.coin_settings')}}</h1>

            <div class="border-bottom row">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.coin_settings')}}</li>
                    </ol>
                </div>
            </div>

            <ul class="nav nav-pills custom-tabs inline-tabs" id="pills-tab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="spin_wheel-tab" data-toggle="tab" href="#spin_wheel" role="tab" aria-controls="spin_wheel" aria-selected="false">{{__('label.spin_wheel')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="daily_reward-tab" data-toggle="tab" href="#daily_reward" role="tab" aria-controls="daily_reward" aria-selected="true">{{__('label.daily_reward')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="ads_free_reward-tab" data-toggle="tab" href="#ads_free_reward" role="tab" aria-controls="ads_free_reward" aria-selected="true">{{__('label.ads_free_reward')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="withdrawal_setting-tab" data-toggle="tab" href="#withdrawal_setting" role="tab" aria-controls="withdrawal_setting" aria-selected="true">{{__('label.withdrawal_setting')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="coin_share-tab" data-toggle="tab" href="#coin_share" role="tab" aria-controls="coin_share" aria-selected="false">{{__('label.coin_share')}}</a>
                </li>
            </ul>

            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="spin_wheel" role="tabpanel" aria-labelledby="spin_wheel-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('label.spin_wheel_setting')}}</h5>
                        <div class="card-body">
                            <form id="spin_wheel_setting" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_1')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="1" min="0" class="form-control" value="{{ $reward_setting['1'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_2')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="2" min="0" class="form-control" value="{{ $reward_setting['2'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_3')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="3" min="0" class="form-control" value="{{ $reward_setting['3'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_4')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="4" min="0" class="form-control" value="{{ $reward_setting['4'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_5')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="5" min="0" class="form-control" value="{{ $reward_setting['5'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_6')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="6" min="0" class="form-control" value="{{ $reward_setting['6'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_7')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="7" min="0" class="form-control" value="{{ $reward_setting['7'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_8')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="8" min="0" class="form-control" value="{{ $reward_setting['8'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="spin_wheel_setting()">{{__('label.save')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="daily_reward" role="tabpanel" aria-labelledby="daily_reward-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('label.daily_reward')}}</h5>
                        <div class="card-body">
                            <form id="daily_reward_coin" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.day_1')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-1" min="0" class="form-control" value="{{ $reward_setting['day-1'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.day_2')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-2" min="0" class="form-control" value="{{ $reward_setting['day-2'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.day_3')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-3" min="0" class="form-control" value="{{ $reward_setting['day-3'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.day_4')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-4" min="0" class="form-control" value="{{ $reward_setting['day-4'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_5')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-5" min="0" class="form-control" value="{{ $reward_setting['day-5'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_6')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-6" min="0" class="form-control" value="{{ $reward_setting['day-6'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.key_7')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="day-7" min="0" class="form-control" value="{{ $reward_setting['day-7'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="daily_reward_coin()">{{__('label.save')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="ads_free_reward" role="tabpanel" aria-labelledby="ads_free_reward-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('label.ads_free_reward')}}</h5>
                        <div class="card-body">
                            <form id="ads_free_coin" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('label.ads_free_coin')}}<span class="text-danger">*</span></label>
                                            <input type="number" name="ads_free_coin" min="0" class="form-control" value="{{ $reward_setting['ads_free_coin'] }}" placeholder="{{__('label.coin_here')}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="ads_free_reward()">{{__('label.save')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="withdrawal_setting" role="tabpanel" aria-labelledby="withdrawal_setting-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('label.withdrawal_setting')}}</h5>
                        <div class="card-body">
                            <form id="withdrawal_setting_save" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.withdrawal_coin_status')}}<span class="text-danger">*</span></label>
                                                <div class="radio-group">
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="withdrawal_coin_status" id="withdrawal_coin_status_on" class="custom-control-input" {{ $setting_data['withdrawal_coin_status'] == '1' ? "checked" : "" }} value="1">
                                                        <label class="custom-control-label" for="withdrawal_coin_status_on">{{__('label.on')}}</label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="withdrawal_coin_status" id="withdrawal_coin_status_off" class="custom-control-input" {{ $setting_data['withdrawal_coin_status'] == '0' ? "checked" : "" }} value="0">
                                                        <label class="custom-control-label" for="withdrawal_coin_status_off">{{__('label.off')}}</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.min_withdrawal_coins')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="min_withdrawal_coin" value="{{ $setting_data['min_withdrawal_coin'] }}" min="0" class="form-control" placeholder="{{__('label.min_withdrawal_coins_here')}}" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-2">
                                                <label>{{__('label.coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="earning_per_coin" min="0" class="form-control" value="{{ $setting_data['earning_per_coin'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-1">
                                                <label class="d-flex justify-content-center align-items-center">=</label>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label>{{__('label.amount')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="coin_per_amount" min="0" class="form-control" value="{{ $setting_data['coin_per_amount'] }}" placeholder="{{__('label.amount_here')}}">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label>{{__('label.currency')}}</label>
                                                <input type="text" readonly class="form-control" value="{{ $setting_data['currency'] }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="withdrawal_setting()">{{__('label.save')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="coin_share" role="tabpanel" aria-labelledby="coin_share-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('label.coin_share_setting')}}</h5>
                        <div class="card-body">
                            <form id="coin_share_setting" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <label>{{__('label.min_coin_share')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="min_coin_share" min="0" class="form-control" value="{{ $setting_data['min_coin_share'] }}" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="coin_share_setting()">{{__('label.save')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        function spin_wheel_setting() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#spin_wheel_setting")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.coinsetting.spin_wheel") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'spin_wheel_setting', '{{ route("admin.coinsetting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
        function daily_reward_coin() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#daily_reward_coin")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.coinsetting.daily_reward") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'daily_reward_coin', '{{ route("admin.coinsetting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
        function ads_free_reward() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#ads_free_coin")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.coinsetting.ads_free_coin") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'ads_free_coin', '{{ route("admin.coinsetting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
        function withdrawal_setting() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#withdrawal_setting_save")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.coinsetting.withdrawal") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'withdrawal_setting_save', '{{ route("admin.coinsetting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
        function coin_share_setting() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#coin_share_setting")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.coinsetting.coin_share") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'coin_share_setting', '{{ route("admin.coinsetting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
    </script>
@endsection